# -*- coding: utf-8 -*-
"""
Created on Thu Sep 10 17:47:04 2020

@author: ɱa®₡Ѳs
"""
import os
import  gpiozero
import time
import sqlite3
import subprocess
from smbus2 import SMBus
from shutil import copyfile
from PyQt5 import QtCore, QtWidgets, QtGui 
from MainWindow import Ui_MainWindow # tenho de chamar esta .py e sua classe para mudar o layout da app quando quiser
from lista_de_dispositivos import Ui_Lista_de_Dispositivos
from Adicionar_Dispositivo_DB import Ui_Adicionar_Dispositivos_DB_Dialog
from Apagar_Dispositivo_DB import Ui_Apagar_Dispositivos_DB_Dialog
import funcoes
import pcb_files

# SEMPRE QUE ATUALIZAR OS FICHEIROS .ui NO QTDESIGNER .... ATUALIZAR NOS FICHEIROS .py CAMINHO DO ICONS /home/pi/Easy2repair_app/NOME_DO_ICON.png
destination_folder= "/home/pi/Easy2repair_app/scripts_pcbs/"
image_destination_folder= "/home/pi/Easy2repair_app/dispositivos_imagens/"
caminho_aplicacao = "/home/pi/Easy2repair_app/"
base_dados="/home/pi/Easy2repair_app/dispositivos_easy2repair.db"
tabela="Tabela_Dispositivos"
id_dispositivo="id_Dispositivo"
nome_ficheiro="pcb_files.py"
abre_app="Easy2Repair"

class MainWindow(QtWidgets.QMainWindow , Ui_MainWindow):
    numero=["0","1","2","3","4","5","6","7","8","9","x"]
    leitura_adc_signal = QtCore.pyqtSignal(int,int) # ncanal,casas_decimais
    verifica_medicao_signal = QtCore.pyqtSignal(int,int,float,float,float) #ncanal,casas_decimais,valor_nominal,valor_min,valor_max
    
    def __init__(self, *args, **kwargs):
        super(MainWindow, self).__init__(*args, **kwargs)
        # INICIALIZAR OS OBJECTOS DA APLICAcAO
        self.setupUi(self)
        
        # INICIALIZA CONTROLO DO RELE
        self.rele=gpiozero.LED("GPIO17")
        
        # CENTRAR APLICAcaO + RESET AOS WIDGETS
        self.centrar_app()
        funcoes.reset_sistema(self)
        
        # VARIAVEL LIVRE - PODE SER USADA POR TODAS AS PLACAS
        self.var_livre = None
        
        # ADC - INICIALIZACAO DO ADC + CONNECT DO SINAL DE CADA FUNCAO + VARIAVEIS DO PROCESSO
        self.adcs = [gpiozero.MCP3208(channel=canal, differential=False,
                    max_voltage=3.3, port=0, device=0) for canal in range(8)]
                    # quanto mais preciso for estes 3.3 mais precisa é a medicao
        self.leitura_adc_signal.connect(self.leitura_adc)
        self.verifica_medicao_signal.connect(self.verifica_medicao)
        self.resultado_leitura_adc = None
        self.resultado_verifica_medicao = None
        self.vdc_media = None
        
        #VARIAVEL GLOBAL FTDI.PY/I2C.PY
        self.endereco_pca = None
        self.var = None
        self.valor_registo = None
        self.var_2=None
        
        # INICIALIZAR GESTOR DE ATENDIMENTO DE THREADS
        # self.threadpool = QtCore.QThreadPool()
        # print("Multithreading with maximum %d threads" % self.threadpool.maxThreadCount())
        
        #PARAMETRO MENU VERIFICAcAO INSERcAO DE ESCOLHA
        self.parametro = None
        self.escolha = None
        self.escolha_numero_inserido = None
        self.func_ajuda = None
        self.func_ajuda_pos_escolha_endereco = None
        self.num_relays_params=None
        self.nome_do_script_running = None
        self.menu_or_escolha = None
        
        # VARIVEL GLOBAL DO ENDEREcO/ERRO A ENCONTRAR ENDEREcO
        self.endereco = None
        self.stdErrValue = None
        
        # VARIAVEL GLOBAL I2C BUS
        self.i2c = SMBus(1) # Raspberry mais recentes -> 1 mas o mais antigo -> 0
        
        # VERIFICA MUDANcA NA ESCOLHA DO DISPOSITIVO NO DROPDOWN
        self.Nome_da_placa.currentIndexChanged.connect(lambda numero=MainWindow.numero: funcoes.selectionchange(self))
        
        #ATUALIZA OS NOMES DAS PLACAS
        funcoes.atualiza_nomes_placas(self, destination_folder)
               
        #BOTOES_BARRA_TAREFAS
        self.actionExit.triggered.connect(self.close)
        self.actionActualizar_Dispositivos.triggered.connect(lambda numero=MainWindow.numero: funcoes.atualiza_nomes_placas(self, destination_folder))
        self.actionLista_de_Dispositivos.triggered.connect(lambda numero=MainWindow.numero: MainWindow.lista_dispositivos(self))
        
        #BOTOES
        self.pushButton_iniciar.pressed.connect(lambda numero=MainWindow.numero: MainWindow.func_pcb(self))
        self.pushButton_n0.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[0]))
        self.pushButton_n1.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[1]))
        self.pushButton_n2.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[2]))
        self.pushButton_n3.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[3]))
        self.pushButton_n4.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[4]))
        self.pushButton_n5.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[5]))
        self.pushButton_n6.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[6]))
        self.pushButton_n7.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[7]))
        self.pushButton_n8.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[8]))
        self.pushButton_n9.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[9]))
        self.pushButton_x.pressed.connect( lambda numero=MainWindow.numero: funcoes.func_imprime_escolha(self,MainWindow.numero[10])) # sem o lambda nao funciona
        self.pushButton_apagar.pressed.connect(lambda numero=MainWindow.numero: funcoes.func_apagar_ultimo_carater(self))
        self.pushButton_enter.pressed.connect(lambda numero=MainWindow.numero: funcoes.enter_verifica_escolha(self,self.parametro)) # self.pushButton_enter.pressed.connect(lambda numero=MainWindow.numero: MainWindow.pressionando_botao_enter(self))
    
    # ABRE LISTAGEM DE DISPOSITIVOS - BASE DE DADOS
    def lista_dispositivos(self):
        dlg = Lista_Dispositivos(self)
        dlg.showMaximized()     
    
    # FUNcAO CHAMA A FUNcAO MAIN DO SCRIPT DA PCB ESCOLHIDA DO DROPDOWN
    def func_pcb(self):
            script = self.nome_do_script           # VARIAVEL "GLOBAL" OBTIDA SEMPRE QUE MUDA O TEXTO DO DROPDOWN
            if self.nome_do_script != "Escolha um Dispositivo":
                funcoes.func_imprime_gui(self,"",1) # Limpa texto antes de iniciar script da pcb
                self.nome_do_script_running=script  # GUARDA A SCRIPT QUE ESTA A CORRER
                print("script",script)
                getattr(pcb_files, script).main(self)
            if self.nome_do_script == "Escolha um Dispositivo":
                string="Escolha um dispositivo da lista e clique em INICIAR!!!"
                funcoes.func_imprime_gui(self,string,1)
                
    # FUNcAO PARA CENTRAR APP SEMPRE QUE ESTA INICIA
    def centrar_app(self):
        qr=self.frameGeometry()
        cp=QtWidgets.QDesktopWidget().availableGeometry().center()
        qr.moveCenter(cp)
        self.move(qr.topLeft())
    
     ############## FUNCOES DEDICADAS ÀS MEDICOES DO ADC ###############
    def average(self,lst):
        var = sum (lst)/len(lst)    
        self.vdc_media=var
        
    def leitura_adc(self,ncanal,casas_decimais): # (self,ncanal, adc_max_volt_ref, casas_decimais)
        vect_leituras=[]
        canal={1:0, 2:1, 3:2, 4:3, 5:4, 6:5, 7:6, 8:7}
        leitura=0
        x=0
        for i in range(15): # vai fazer 15 medicoes
            leitura=self.adcs[canal[ncanal]].voltage
            x=round(leitura,casas_decimais)
            vect_leituras.append(x)
            x=0
            leitura=0
        time.sleep(0.1) # SE TIRAR ESTE TEMPO - FICA MUITO RAPIDO
        self.average(vect_leituras) # faz a media das 15 leituras
        print("média da leitura realizada: ",self.vdc_media)
        self.resultado_leitura_adc=str(round(self.vdc_media,casas_decimais))
        
    def verifica_medicao(self,ncanal, casas_decimais, valor_nominal, valor_min, valor_max): # (self,ncanal, adc_max_volt_ref, casas_decimais, valor_nominal, valor_min, valor_max)
        self.leitura_adc_signal.emit(ncanal, casas_decimais)
        ler_contato=self.resultado_leitura_adc
        ler_contato=float(ler_contato)
        if ler_contato < valor_nominal:
            if ler_contato < valor_min:
                string="Componente MAU ... Medicao: "+str(ler_contato)+"V"
                funcoes.func_imprime_gui(self,string,1)
                self.resultado_verifica_medicao=0
            else:
                string="Componente BOM ... Medicao: "+str(ler_contato)+"V"
                funcoes.func_imprime_gui(self,string,1)
                self.resultado_verifica_medicao=1
        if ler_contato > valor_nominal:
            if ler_contato < valor_max:
                string="Componente BOM ... Medicao: "+str(ler_contato)+"V"
                funcoes.func_imprime_gui(self,string,1)
                self.resultado_verifica_medicao=1
            else:
                string="Componente MAU ... Medicao: "+str(ler_contato)+"V"
                funcoes.func_imprime_gui(self,string,1)
                self.resultado_verifica_medicao=0    
            ##################################################    
      
# CLASSES PARA GESTaO DA BASE DE DADOS - VER/APAGAR/ATUALIZAR
class Lista_Dispositivos(QtWidgets.QMainWindow, Ui_Lista_de_Dispositivos):
    def __init__(self, *args, **kwargs):
        super(Lista_Dispositivos, self).__init__(*args, **kwargs)  
        self.setupUi(self)
        # Botoes da Tabela 
        self.actionActualizar_Lista_Dispositivos.triggered.connect(self.showTableData)
        self.actionAdicionar_Dispositivo.triggered.connect(self.Adicionar_Dispositivo_DB_click)
        self.actionApagar_dispositivo.triggered.connect(self.Apagar_Dispositivo_DB_click)
        self.actionExit.triggered.connect(self.close)
        # cria label no toolbar
        self.toolBar.addSeparator()
        self.label_toolbar=QtWidgets.QLabel("Número de Dispositivos presentes: "+str(self.Tabela_Dispositivos.rowCount()))
        self.toolBar.addWidget(self.label_toolbar)
        self.toolBar.addSeparator()
        Lista_Dispositivos.showTableData(self) # para atualizar a lista assim que janela abre

    # chama janela com formulario para adicionar dispositivo à base de dados
    def Adicionar_Dispositivo_DB_click(self):
        dlg = Dialog_Adicionar_DB(self)
        dlg.exec_()
        Lista_Dispositivos.showTableData(self)
        
    # chama janela para apagar dispositivo da base de dados
    def Apagar_Dispositivo_DB_click(self):
        dlg = Dialog_Apagar_DB(self)
        dlg.exec_()
        Lista_Dispositivos.showTableData(self)

    # método que obtem imagem da base de dados
    def getImageLabel(self,image):
        imageLabel = QtWidgets.QLabel() # self.centralWidget)
        imageLabel.setText("")
        imageLabel.setScaledContents(True)
        pixmap = QtGui.QPixmap()
        pixmap.loadFromData(image,'jpg') # cuidado com isto, se for outra extensao pode nao dar
        imageLabel.setPixmap(pixmap)
        return imageLabel
             
    # mostra tabela
    def showTableData(self):
        try:
            self.dbConnection = sqlite3.connect(base_dados) # inicia conexao com a base de dados
            print("Abriu conexao com a base de dados!")
            query="""SELECT * FROM {}"""
            result=self.dbConnection.cursor().execute(query.format(tabela))
            self.Tabela_Dispositivos.setRowCount(0) # Aqui Limpo o Widget da Tabela
            for row_number, row_data in enumerate(result):
                self.Tabela_Dispositivos.insertRow(row_number)
                for column_number, column_data in enumerate(row_data):
                    item=str(column_data)
                    if column_number == 0:
                        item = self.getImageLabel(column_data)
                        self.Tabela_Dispositivos.setCellWidget(row_number, column_number, item)
                    else:
                        # print("o item é:",item)
                        item = QtWidgets.QTableWidgetItem(item) # create the item
                        item.setTextAlignment(QtCore.Qt.AlignCenter) # change the alignment
                        self.Tabela_Dispositivos.setItem(row_number, column_number, item)        
            # caso já haja placas na lista nao executa proxima linha
            self.label_toolbar.setText("Número de Dispositivos presentes: "+str(self.Tabela_Dispositivos.rowCount()))
            self.dbConnection.commit()
            self.dbConnection.close() # fecha conexao com DB
            print("Fechou conexao com a base de dados!")
            if self.Tabela_Dispositivos.rowCount()==0:
                dlg = QtWidgets.QMessageBox(self)
                dlg.setWindowTitle("Alerta!")
                dlg.setText("Base de Dados está vazia!\n            Verificar!")
                dlg.exec_()
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()

# Adiciona Dispositivos à base de dados           
class Dialog_Adicionar_DB(QtWidgets.QDialog, Ui_Adicionar_Dispositivos_DB_Dialog):
    numero = []
    def __init__(self, *args, **kwargs):  # <1>
        super(Dialog_Adicionar_DB, self).__init__(*args, **kwargs)#  )
        self.setupUi(self)
        print("Abertura da Janela de Inserir Dispositivo na Base de Dados")
        # Botões e Texto
        self.Escolher_ficheiro_Imagem.pressed.connect(lambda numero=Dialog_Adicionar_DB.numero: Dialog_Adicionar_DB.escolher_imagem_click(self))
        self.Escolher_ficheiro_Programa.pressed.connect(lambda numero=Dialog_Adicionar_DB.numero: Dialog_Adicionar_DB.escolher_ficheiro_click(self))
        self.buttonBox_save_cancel_add_dispositivo.accepted.connect(lambda numero=Dialog_Adicionar_DB.numero: Dialog_Adicionar_DB.save_db_click(self))
        self.label_validacao_formulario.setText("Preencher Formulário Acima")
        # Variáveis da Classe
        self.imagem_selecionada=None
        self.ficheiro_python=None
        self.nr_dispositivos_db=None
    
    # conta as linhas na base de dados
    def db_row_count(self):
        x=0
        try:
            with sqlite3.connect(base_dados) as connection:
                print("Conexao com Base Dados Aberta!")
                cursor = connection.cursor()
                query="""SELECT * FROM {}"""
                cursor.execute(query.format(tabela))
                records=cursor.fetchall()
                # print("records",records)
                for row in records:
                    if row!="": # linha tem informacao ?
                        x=x+1
                        # print("x:",x)
                if records==[]:
                    print("base dados vazia")
                    x=1 # se tiver vazia mete o id=1 no 1o dispositivo
                self.nr_dispositivos_db=x+1
                connection.commit()
                cursor.close()
                print("Conexao com Base Dados Fechada!")
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()
            
    # Convert digital data to binary format 
    def convertToBinaryData(filename):
        with open(filename, 'rb') as file:
            blobData = file.read()
        return blobData
    
    # funcao click do botao    
    def escolher_imagem_click(self):
        source_file_path,filters= QtWidgets.QFileDialog.getOpenFileName(parent=self, caption='Open file', filter='imagens .jpg (*.jpg)')
        filename = QtCore.QFileInfo(source_file_path).fileName()
        print(filename)
        if filename!="":
            self.label_imagem_carregada.setText(filename)
            self.imagem_selecionada=source_file_path
        
    def escolher_ficheiro_click(self):
        source_file_path,filters= QtWidgets.QFileDialog.getOpenFileName(parent=self, caption='Open file', filter='Ficheiros .py (*.py)')
        filename = QtCore.QFileInfo(source_file_path).fileName()
        print(filename)
        if filename!="":
            self.label_programa_carregado.setText(filename)
            self.ficheiro_python=source_file_path
            
    def verifica_nr_maze(self,string):
        y=0
        for x in string:
            if x.isnumeric():
                y=y+1
            if x==".":
                y=y+1
        return y
            
    def save_db_click(self):
        form_validation=0
        string=self.nr_maze.text()
        if form_validation==0:
            if self.nome_do_dispositivo.text()!="":
                print("nome ok")
                if self.label_imagem_carregada.text() != "  (Escolher Ficheiro .jpg)":
                    print("imagem ok")
                    if self.label_programa_carregado.text() != "  (Escolher Ficheiro Python)":
                        print("programa ok")
                        if self.nr_maze.text() != "":
                            print("nr.maze ok 1")
                            if self.verifica_nr_maze(string)==12 or self.verifica_nr_maze(string)==24:
                                print("nr.maze ok 2")
                            else:
                                form_validation=5
                        else:
                            form_validation=4
                    else:
                        form_validation=1
                else:
                    form_validation=2
            else:
                form_validation=3
        if form_validation!=0: # entao é porque falta alguma cena no Form
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Erro!")
            if form_validation==1:
                dlg.setText("Selecionar o ficheiro Python!")
            if form_validation==2:
                dlg.setText("Selecionar a Imagem do Dispositivo!")
            if form_validation==3:
                dlg.setText("Escrever o Nome do Dispositivo!")
            if form_validation==4:
                dlg.setText("Escrever o Número Maze do Dispositivo!")
            if form_validation==5:
                dlg.setText("Número Maze deve ter o formato: nnnn.nnn.nnn")
            dlg.exec_()
            Dialog_Adicionar_DB(self).exec_()
        else:
            imagem_selecionada = Dialog_Adicionar_DB.convertToBinaryData(self.imagem_selecionada)
            ficheiro_python = Dialog_Adicionar_DB.convertToBinaryData(self.ficheiro_python)
            Dialog_Adicionar_DB.db_row_count(self)
            data = (imagem_selecionada, self.nome_do_dispositivo.text(),self.label_programa_carregado.text(),self.nr_maze.text(),ficheiro_python,self.nr_dispositivos_db)
            
            print("vou verificar ficheiro python e imagem!!")
            Dialog_Adicionar_DB.verifica_existencia_ficheiro_python(self,QtCore.QFileInfo(self.ficheiro_python).fileName(),self.ficheiro_python)
            Dialog_Adicionar_DB.verifica_existencia_imagem(self,QtCore.QFileInfo(self.imagem_selecionada).fileName(),self.imagem_selecionada)
            print("Vou escrever na Base de Dados")
            Dialog_Adicionar_DB.escreve_na_base_dados(self,data)
            reply=QtWidgets.QMessageBox.question(self, 'ATENcaO',
                                           'Deve fazer restart à aplicacao!.\nContinuar?', 
                                           buttons=QtWidgets.QMessageBox.Yes | QtWidgets.QMessageBox.No, 
                                           defaultButton=QtWidgets.QMessageBox.No)
            if reply == QtWidgets.QMessageBox.Yes:
                Lista_Dispositivos.close(self) # fecha lista de dispositivos
                MainWindow.close(self)
                subprocess.Popen('/home/pi/Desktop/'+abre_app) #.... faz restart à app - abre duas janelas da app !! esquesito
                # abrir app de novo
            else:
                QtWidgets.QMessageBox.question(self, 'ATENcaO',
                                           'Deve fazer restart à aplicacao mais tarde!')
        
    def escreve_na_base_dados(self,data):
        try:
            with sqlite3.connect(base_dados) as connection:
                print("Conexao com Base Dados Aberta!")
                cursor = connection.cursor()
                cursor.execute("INSERT INTO "+tabela+" VALUES(?, ?, ?, ?, ?, ?);", data)
                dlg = QtWidgets.QMessageBox(self)
                dlg.setWindowTitle("Sucesso!")
                dlg.setText("Escrita na Base de Dados com sucesso!")
                dlg.exec_()
                connection.commit()
                cursor.close()
                print("Conexao com Base Dados Fechada!")
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()

    # ESCREVE NO PCB_FILES
    # def escreve_ficheiro(caminho,nome_ficheiro,script_file): # OK
    #      file=open(str(caminho)+str(nome_ficheiro),"a")
    #      file.write(str("import scripts_pcbs.")+str(script_file)+str(" as ")+str(script_file)+"\n")
    #      file.close()
         
    # LÊ DO PCB_FILES  
    def ler_ficheiro(caminho,nome_ficheiro): # OK
        lista=[]
        file = open(str(caminho)+str(nome_ficheiro),"r")
        for string_lida in file: # lê até fim do ficheiro
            # print(string_lida)
            lista.append(string_lida)
        file.close()
        return lista     
    
    # AO ESCOLHER FICHEIRO VERIFICA SE JÁ EXISTE FICHEIRO, S/NAO COPIA P/PASTA
    def verifica_existencia_ficheiro_python(self,filename,source_file_path): # OK - TESTADO
        if os.path.isfile(destination_folder+str(filename)): # SE JÁ EXISTIR FICHEIRO SURGE MENSAGEM
            reply = QtWidgets.QMessageBox.question(self, 'ATENcaO - Ficheiro já existe',
                                           'Ficheiro será substituído.\nContinuar?', 
                                           buttons=QtWidgets.QMessageBox.Yes | QtWidgets.QMessageBox.No, 
                                           defaultButton=QtWidgets.QMessageBox.No)
            if reply == QtWidgets.QMessageBox.Yes:
                copyfile(str(source_file_path),destination_folder+str(filename))
                self.label_validacao_formulario.setText("Ficheiro "+str(filename)+"\ncarregado com sucesso !")
                conteudo_ficheiro = Dialog_Adicionar_DB.ler_ficheiro(caminho_aplicacao,nome_ficheiro) # lê pcb_files.py
                
                if "import scripts_pcbs."+str(filename)+str(" as ")+str(filename)+"\n" not in conteudo_ficheiro: # escreve no ficheiro import nome_script se nao tiver
                    ponto_final=filename.find(".")
                    filename=filename[:ponto_final] # isto é para nao escrever o .py associado ao script
                    funcoes.escreve_ficheiro_pcb_files(caminho_aplicacao,nome_ficheiro,str(filename))
                    
                else:
                    string="pcb_files.py já tem o nome do ficheiro importado no seu conteudo"
                    print(string)
                    self.label_validacao_formulario.setText(string)
            else:
                self.label_validacao_formulario.setText("Operacao Cancelada!")
        else: # se nao existir ficheiro no destino entao faz a cópia
            copyfile(str(source_file_path),destination_folder+str(filename))
            self.label_validacao_formulario.setText("Ficheiro "+str(filename)+"\ncarregado com sucesso !")
            ponto_final=filename.find(".")
            filename=filename[:ponto_final] # isto é para nao escrever o .py associado ao script
            funcoes.escreve_ficheiro_pcb_files(caminho_aplicacao,nome_ficheiro,str(filename))
            
    def verifica_existencia_imagem(self,filename,source_file_path):
        if os.path.isfile(image_destination_folder+str(filename)): # SE JÁ EXISTIR imagem SURGE MENSAGEM
            reply = QtWidgets.QMessageBox.question(self, 'ATENcaO - Imagem já existe',
                                           'Imagem será substituída.\nContinuar?', 
                                           buttons=QtWidgets.QMessageBox.Yes | QtWidgets.QMessageBox.No, 
                                           defaultButton=QtWidgets.QMessageBox.No)
            if reply == QtWidgets.QMessageBox.Yes:
                copyfile(str(source_file_path),image_destination_folder+str(filename))
                self.label_validacao_formulario.setText("Imagem "+str(filename)+"\ncarregado com sucesso !")
            else:
                self.label_validacao_formulario.setText("Operacao Cancelada!")
        else: # se nao existir ficheiro no destino entao faz a cópia
            copyfile(str(source_file_path),image_destination_folder+str(filename))
            self.label_validacao_formulario.setText("Imagem "+str(filename)+"\ncarregado com sucesso !")
                
# Apaga Dispositivos da base de dados   
class Dialog_Apagar_DB(QtWidgets.QDialog, Ui_Apagar_Dispositivos_DB_Dialog):
    def __init__(self, *args, **kwargs):  # <1>
        super(Dialog_Apagar_DB, self).__init__(*args, **kwargs)#  )
        self.setupUi(self)
        print("Abertura da Janela de Apagar Dispositivo na Base de Dados")   
        # botao save e emissao do sinal mudanca de escolha do user
        self.buttonBox.accepted.connect(self.func_chama_func_apagar_linha)
        self.lista_dispositivos.itemClicked.connect(self.list_name_changed)
        Dialog_Apagar_DB.lista_dispositivos_db(self)
        # variavel
        self.dispositivo_escolhido_lista=None          # index
        self.nome_dispositivo_escolhido_lista=None     # nome
        self.ficheiro_dispositivo_escolhido_lista=None # ficheiro
        # ordena indexs
        Dialog_Apagar_DB.obtem_ids_ordena_base_dados(self)
    
    # sempre que escolhemos uma placa guarda a escolha  
    def list_name_changed(self, s):
        self.dispositivo_escolhido_lista=self.lista_dispositivos.currentRow()+1
        self.nome_dispositivo_escolhido_lista=s.text()
        self.ficheiro_dispositivo_escolhido_lista=Dialog_Apagar_DB.devolve_um_valor_DB(self,"Programa",self.dispositivo_escolhido_lista)
        print("dispositivo selecionado:",s.text())
        print("index dispositivo selecionado:",self.dispositivo_escolhido_lista)
        print("programa selecionado:",self.ficheiro_dispositivo_escolhido_lista)
            
    # query à base de dados e lista os nomes das placas
    def lista_dispositivos_db(self):
        try:
            with sqlite3.connect(base_dados) as connection:
                print("Conexao com Base Dados Aberta!")
                cursor = connection.cursor()
                query="""SELECT * FROM {}"""
                cursor.execute(query.format(tabela))
                records = cursor.fetchall()
                for row in records:
                    self.lista_dispositivos.addItem(row[1])
                connection.commit()
                cursor.close()
                print("Conexao com Base Dados Fechada!")
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()

    # funcao chama a func de apagar da base de dados
    def func_chama_func_apagar_linha(self):
        Dialog_Apagar_DB.apaga_ficheiro_edita_pcb_files(self)
        Dialog_Apagar_DB.apaga_da_base_dados(self,self.dispositivo_escolhido_lista) # linha
        # funcoes.atualiza_nomes_placas(self, destination_folder) # Depois de apagar atualiza a listagem automaticamente
        
    def apaga_ficheiro_edita_pcb_files(self):
        string=".{} as {}\n"
        os.remove(destination_folder+self.ficheiro_dispositivo_escolhido_lista) # apaga ficheiro python da pasta
        # codigo abaixo cria novo ficheiro com info sem ficheiro apagado, depois edita o pcb_files
        with open(caminho_aplicacao+nome_ficheiro, "r") as f:
            lines = f.readlines()
        ponto_final=self.ficheiro_dispositivo_escolhido_lista.find(".")
        self.ficheiro_dispositivo_escolhido_lista=self.ficheiro_dispositivo_escolhido_lista[:ponto_final] 
        # isto é para nao escrever o .py associado ao script
        with open(caminho_aplicacao+"pcb_files_2.txt", "w") as f:
            for line in lines:
                if line.strip("import scripts_pcbs") != string.format(self.ficheiro_dispositivo_escolhido_lista,self.ficheiro_dispositivo_escolhido_lista):
                    f.write(line)
        pcb_files_2 = open(caminho_aplicacao+'pcb_files_2.txt').read()
        pcb_files = open(caminho_aplicacao+nome_ficheiro, 'w')
        pcb_files.write(pcb_files_2)
        pcb_files.close()
        print("Apaguei o ficheiro .py da pasta e editei o pcb_files.py")
    
    # RETORNA VALOR DE UMA DETERMINADA COLUNA E LINHA DA BASE DE DADOS EM STRING
    def devolve_um_valor_DB(self,coluna,linha): # coluna = Programa
        lista=[]
        try:
            with sqlite3.connect(base_dados) as connection:
                print("Conexao com Base Dados Aberta!")
                cursor = connection.cursor()
                query="""SELECT {} FROM {} WHERE {}=?"""
                cursor.execute(query.format(coluna,tabela,id_dispositivo),str(linha))
                records = cursor.fetchall()
                for row in records:
                    lista.append(row[0])
                connection.commit()
                cursor.close()
                print("Conexao com Base Dados Fechada!")
                return lista[0]
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()
        
    # abre base de dados e apaga linha
    def apaga_da_base_dados(self,linha):
        dlg = Alerta(self)
        if dlg.exec_():
            try:
                print("Vou apagar da base de dados")
                with sqlite3.connect(base_dados) as connection:
                    print("Conexao com Base Dados Aberta!")
                    cursor = connection.cursor()
                    query="""DELETE from {} WHERE {} = ?"""
                    cursor.execute(query.format(tabela,id_dispositivo),str(linha))
                    dlg = QtWidgets.QMessageBox(self)
                    dlg.setWindowTitle("Sucesso!")
                    dlg.setText("Escrita na Base de Dados com sucesso!")
                    dlg.exec_()
                    connection.commit()
                    cursor.close()
                    print("Conexao com Base Dados Fechada!")
                    Dialog_Apagar_DB.obtem_ids_ordena_base_dados(self)
            except sqlite3.Error as error:
                print("Falha de abertura da conexao com base de dados: ", error)
                dlg = QtWidgets.QMessageBox(self)
                dlg.setWindowTitle("Alerta!")
                dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
                dlg.exec_()
        else:
            print("Nao vou apagar da base de dados")
        
    # liga à base de dados e atualiza ids dos dispositivos 
    def func_atualiza_ids_dispositivos_db(self,data):
        try:
            print("Vou atualizar da base de dados")
            with sqlite3.connect(base_dados) as connection:
                print("Conexao com Base Dados Aberta!")
                cursor = connection.cursor()
                query="""UPDATE {} SET {} = ? WHERE {} = ?""" # novo valor / antigo valor
                cursor.executemany(query.format(tabela,id_dispositivo,id_dispositivo),data)
                connection.commit()
                cursor.close()
                print("Conexao com Base Dados Fechada!")
        except sqlite3.Error as error:
            print("Falha de abertura da conexao com base de dados: ", error)
            dlg = QtWidgets.QMessageBox(self)
            dlg.setWindowTitle("Alerta!")
            dlg.setText("Falha de abertura da conexao com base de dados:"+str(error))
            dlg.exec_()
    
    def devolve_vetor_int_recebe_num(minim,maxim):
        parametro=[]
        for i in range(minim,maxim+1): 
            parametro.append(i)
            i=int(i)
        return parametro
        
    def obtem_ids_ordena_base_dados(self): # se houver ids repetidos nao funciona bem
        lista_=[]
        lista=[]
        lista2=[]
        lista3=[]
        # Conexao com base dados e obtem vetor dos ids - OK
        with sqlite3.connect(base_dados) as connection:
            print("Conexao com Base Dados Aberta!")
            cursor = connection.cursor()
            query="""SELECT * FROM {}"""
            cursor.execute(query.format(tabela))
            records = cursor.fetchall()
            for row in records:
                lista.append(row[5])
            connection.commit()
            cursor.close()
            print("Conexao com Base Dados Fechada!")
        lista2=Dialog_Apagar_DB.devolve_vetor_int_recebe_num(1,len(lista))
        lista_=Dialog_Apagar_DB.devolve_vetor_int_recebe_num(0,len(lista)-1)
        for i in lista_:
            var=(lista2[i],lista[i]) # CRIA TUPPLE
            lista3.append(var) # LISTA DE TUPPLES
        # print(lista)  # atual da base de dados
        # print(lista_) # lista de indexs
        # print(lista2) # valores corretos a inserir 
        # print(lista3) # final a passar para a base de dados
        Dialog_Apagar_DB.func_atualiza_ids_dispositivos_db(self,lista3)

# classe que apenas abre janela - verifica se quer continuar ou nao
class Alerta(QtWidgets.QDialog):
    def __init__(self, parent=None):  # <1>
        super().__init__(parent)
        self.setWindowTitle("Alerta!")
        buttons = QtWidgets.QDialogButtonBox.Ok | QtWidgets.QDialogButtonBox.Cancel
        self.buttonBox_ = QtWidgets.QDialogButtonBox(buttons)
        self.buttonBox_.accepted.connect(self.accept)
        self.buttonBox_.rejected.connect(self.reject)
        self.layout = QtWidgets.QVBoxLayout()
        message = QtWidgets.QLabel("Tem a certeza que deseja apagar da Base de Dados o Dispositivo Selecionado?")
        self.layout.addWidget(message)
        self.layout.addWidget(self.buttonBox_)
        self.setLayout(self.layout)


app = QtWidgets.QApplication([])
window = MainWindow()
window.showMaximized() # abre a app em grande, é melhor
app.exec_() 


                             # BUGS
# - AO ESCREVER NA BASE DE DADOS O FICHEIRO PYTHON POR VEZES FICA EM BINÁRIO ------ VERIFICAR

#                                       TO DO
# AO ESCREVER NA BASE DE DADOS ESCREVER 
#     COPIAR IMAGEM PARA PASTA COM DETERMINADO FORMATO DE ACORDO COM id_Dispositivo

# REFERENCIAS IMPORTANTES ABAIXO
# https://pynative.com/python-sqlite-delete-from-table/
# Handling de Base de Dados - Livro do Real Python
# https://www.sqlitetutorial.net/sqlite-delete/
